// SelectCameraDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sample.h"
#include "SelectCameraDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectCameraDlg dialog


CSelectCameraDlg::CSelectCameraDlg(CWnd* pParent)
: CDialog(CSelectCameraDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectCameraDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_nSelectedCamera = -1;
}


void CSelectCameraDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectCameraDlg)
	DDX_Control(pDX, IDC_CAMERA_LIST, m_wndCamList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectCameraDlg, CDialog)
	//{{AFX_MSG_MAP(CSelectCameraDlg)
	ON_LBN_SELCHANGE(IDC_CAMERA_LIST, OnSelchangeCameraList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectCameraDlg message handlers

BOOL CSelectCameraDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	ASSERT_VALID(m_pParentWnd);

	for (POSITION pos = m_lst.GetHeadPosition (); pos != NULL; )
	{
		CString& str = m_lst.GetNext (pos);
		m_wndCamList.AddString (str);
	}

	if (m_lst.GetCount () > 0)
	{
		m_wndCamList.SetCurSel (0);
		m_nSelectedCamera = 0;
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSelectCameraDlg::SetCameraList (const CStringList& lst)
{
	m_lst.AddTail ((CStringList*)&lst);
}

void CSelectCameraDlg::OnSelchangeCameraList() 
{
	UpdateData (TRUE);

	m_nSelectedCamera = m_wndCamList.GetCurSel ();

	if (m_nSelectedCamera == LB_ERR)
	{
		m_nSelectedCamera = -1;
	}
}
